# Counterfactual Influence in Markov Decision Processes

Our work addresses a fundamental problem in the context of counterfactual inference for Markov Decision Processes (MDPs). Given an MDP path $\tau$, this kind of inference allows us to derive counterfactual paths $\tau'$ describing *what-if* versions of $\tau$ obtained under different action sequences than those observed in $\tau$. However, as the counterfactual states and actions deviate from the observed ones over time, *the observation $\tau$ may no longer influence the counterfactual world*, meaning that the analysis is no longer tailored to the individual observation, resulting in interventional outcomes rather than counterfactual ones. Even though this issue specifically affects the popular Gumbel-max structural causal model used for MDP counterfactuals, it has remained overlooked until now. In this work, we introduce a formal characterization of influence based on comparing counterfactual and interventional distributions. We devise an algorithm to construct counterfactual models that automatically satisfy influence constraints. Leveraging such models, we derive counterfactual policies that are not just optimal for a given reward structure but also remain tailored to the observed path. Even though there is an unavoidable trade-off between policy optimality and strength of influence constraints, our experiments demonstrate that it is possible to derive (near-)optimal policies while remaining under the influence of the observation.

## Instructions
The code for running the experiments for each of the three MDP environments can be found in `experiments/`, and should be run with Python 3.10.
The data for the Sepsis experiment can be found [here](https://github.com/GuyLor/gumbel_max_causal_gadgets_part2/tree/main/data). Create a folder called `counterfactual-influence-in-MDPs/data` and add the unzipped `diab_txr_mats-replication.pkl.zip` file in the folder.
The code for generating figures similar to Figure 1 can be found in `experiments/code_for_Figure_1.ipynb`. Pick a generated trajectory for a diabetic patient, and run the counterfactual influence code on this trajectory to produce a figure similar to Figure 1.

## Acknowledgements
The code for the Sepsis MDP is taken from [1], and can be found [here](https://github.com/clinicalml/gumbel-max-scm). This is licensed under the MIT License.

### References
[1] Oberst, M., & Sontag, D. (2019, May). Counterfactual off-policy evaluation with gumbel-max structural causal models. In _International Conference on Machine Learning_ (pp. 4881-4890). PMLR.
